// LED MATRIX CLOCK 24 HOURS WITH ELECTRICAL NETWORK TIME BASE (50Hz). DEFRAN24

#include "LedControl.h"
LedControl lc=LedControl(7,8,6,6); // DIN, CK, CS, NUM.
int HoD=0, HoU=0, MiD=0, MiU=0, SeD=0, SeU=0, Min=3, Hour=4;
int SET=5;
int buz=10;
int SEC=13;
int DPs=0;
int BRI=19;
int SON=18;
int dp;
int inck=2;           // 50Hz Interrupt Input.
int LSET=15;
int ONDA=0;           // Pulses counter
int BR=15;            // Brightness Value.
int fset=48;          // Max 50.

void setup() 
{
  pinMode(SET,  INPUT_PULLUP);
  pinMode(Hour, INPUT_PULLUP);
  pinMode(Min,  INPUT_PULLUP);
  pinMode(BRI,  INPUT_PULLUP);
  pinMode(SON,  INPUT_PULLUP);
  pinMode(buz, OUTPUT);
  pinMode(SEC, OUTPUT);
  pinMode(inck, INPUT);        // Network 50Hz input.
  pinMode(LSET, OUTPUT); 
  digitalWrite(SEC, LOW);
  lc.shutdown(0,false);  lc.shutdown(1,false);  lc.shutdown(2,false);
  lc.shutdown(3,false);  lc.shutdown(4,false);  lc.shutdown(5,false);
  lc.setIntensity(0,BR); lc.setIntensity(1,BR); lc.setIntensity(2,BR);
  lc.setIntensity(3,BR); lc.setIntensity(4,BR); lc.setIntensity(5,BR);
  attachInterrupt(digitalPinToInterrupt(inck), InterCK, RISING); // INTERRUPTION FALLING, RISING.
  noTone(buz);
}

void loop() 
{
  do
  {
    if (ONDA==25) digitalWrite(SEC,HIGH);            // Init of the Second 25
    if (ONDA==fset ) {digitalWrite(SEC,LOW); SeU++;} // End of the second. 50
  }
  while (ONDA<fset); // 50
  ONDA=0;
  if (digitalRead(SON)==LOW) tone(buz, 1000, 60);    // PORT, NOTE, TIME. 
  Escribe();
  AQUI:
  if (digitalRead(SET)==LOW)
  {
    if(digitalRead(BRI)==HIGH) BR=15; else BR=9;      // Set Brightness
    lc.setIntensity(0,BR);                            // Brightness Value
    lc.setIntensity(1,BR);
    lc.setIntensity(2,BR);
    lc.setIntensity(3,BR); 
    lc.setIntensity(4,BR);
    lc.setIntensity(5,BR);
    digitalWrite(LSET,HIGH); 
    digitalWrite(SEC,LOW); 
    delay(300);                                        // For SET Switch 
    if(digitalRead(Min)==LOW)  {SeD=0; SeU=0; MiU++;}  // Set Minuts
    if(digitalRead(Hour)==LOW) {SeD=0; SeU=0;HoU++;}   // Set Hours
    Escribe(); 
  }
  if (digitalRead(SET)==LOW) goto AQUI;
  digitalWrite(LSET,LOW);
}

void InterCK()  // Interruption Subroutine.
{
  ONDA++;
}

void Escribe()
{
  if (SeU %2==0) {DPs=1;} else {DPs=0;}   // Odd_even unit
  if(SeU==10) {SeU=0; SeD++;}
  if(SeD==6)  {SeD=0; SeU=0; MiU++;}
  if(MiU==10) {MiU=0; SeD=0; SeU=0; MiD++;}
  if(MiD==6)  {MiD=0; MiU=0; SeD=0; SeU=0; HoU++;}
  if(HoU==10) {HoU=0; MiD=0; MiU=0; SeD=0; SeU=0; HoD++;}
  if(HoD==2 && HoU==4) {HoD=0; HoU=0; MiD=0; MiU=0; SeD=0; SeU=0;} 
  Digitos(0,SeU);	                                                 // Second Unit. 
  Digitos(1,SeD);	                                                 // Second Ten.
  Digitos(2,MiU);	                                                 // Minute Unit
  Digitos(3,MiD);                                                  // Minute Ten
  Digitos(4,HoU);	                                                 // Hour Unit
  Digitos(5,HoD);	                                                 // Hour Ten
}

void Digitos(int Pos, int Number)
{
  if(Number==0)
  {
    lc.setRow(Pos,0,0x38);
    lc.setRow(Pos,1,0x4c);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); // 3..0 digits.
    lc.setRow(Pos,2,0x4c | dp); // Higher dp.
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00);
    lc.setRow(Pos,3,0x4c | dp); // Higher dp.);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00);
    lc.setRow(Pos,4,0x4c | dp); // Lower dp);
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00);
    lc.setRow(Pos,5,0x4c | dp); // Lower dp);); 
    lc.setRow(Pos,6,0x4c);      // Lower dp);
    lc.setRow(Pos,7,0x38);
  }
  if(Number==1)
  {
    lc.setRow(Pos,0,0x18);
    lc.setRow(Pos,1,0x38);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); // 3..0 digits.
    lc.setRow(Pos,2,0x18 | dp);  // Higher dp.
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,3,0x18 | dp);  // Higher dp.);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00);
    lc.setRow(Pos,4,0x18 | dp);  // Lower dp.);
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00);
    lc.setRow(Pos,5,0x18 | dp);  // Lower dp
    lc.setRow(Pos,6,0x18);
    lc.setRow(Pos,7,0x3c);
  }
  if(Number==2)
  {
    lc.setRow(Pos,0,0x38);
    lc.setRow(Pos,1,0x4c);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); // 3..0 digits.
    lc.setRow(Pos,2,0x0c | dp);  // Higher dp.
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,3,0x0c | dp);  // Higher dp.);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,4,0x18 | dp);  // Lower dp.);
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,5,0x20 | dp);  // Lower dp
    lc.setRow(Pos,6,0x4c);
    lc.setRow(Pos,7,0x7c);
  }
  if(Number==3)
  {
    lc.setRow(Pos,0,0x38);
    lc.setRow(Pos,1,0x4c);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); // 3..0 digits.
    lc.setRow(Pos,2,0x0c | dp);  // Higher dp.
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,3,0x18 | dp);  // Higher dp.);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,4,0x0c | dp);  // Lower dp.);
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,5,0x0c | dp);  // Lower dp
    lc.setRow(Pos,6,0x4c);
    lc.setRow(Pos,7,0x38);
  }
  if(Number==4)
  {
    lc.setRow(Pos,0,0x0c);
    lc.setRow(Pos,1,0x1c);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); // 3..0 digits.
    lc.setRow(Pos,2,0x2c | dp);  // Higher dp.
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,3,0x4c | dp);  // Higher dp.);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00);
    lc.setRow(Pos,4,0x7c | dp);  // Lower dp.);
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00);
    lc.setRow(Pos,5,0x0c | dp);  // Lower dp
    lc.setRow(Pos,6,0x0c);
    lc.setRow(Pos,7,0x1e);
  }
  if(Number==5)
  {
    lc.setRow(Pos,0,0x7c);
    lc.setRow(Pos,1,0x4c);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); // 3..0 digits.
    lc.setRow(Pos,2,0x40 | dp); // Higher dp.
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,3,0x78 | dp);  // Higher dp.);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,4,0x0c | dp);  // Lower dp.);
    if(DPs==0 &&(Pos==2  || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,5,0x0c | dp);  // Lower dp
    lc.setRow(Pos,6,0x4c);
    lc.setRow(Pos,7,0x38);
  }
  if(Number==6)
  {
    lc.setRow(Pos,0,0x38);
    lc.setRow(Pos,1,0x4c);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); // 3..0 digits.
    lc.setRow(Pos,2,0x40 | dp); // Higher dp.
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,3,0x78 | dp);  // Higher dp.);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,4,0x4c | dp);  // Lower dp.);
    if(DPs==0 &&(Pos==2  || Pos==4)) dp=0x01; else (dp=0x00);
    lc.setRow(Pos,5,0x4c | dp);  // Lower dp
    lc.setRow(Pos,6,0x4c);
    lc.setRow(Pos,7,0x38);
  }
  if(Number==7)
  {
    lc.setRow(Pos,0,0x7c);
    lc.setRow(Pos,1,0x4c);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); // 3..0 digits.
    lc.setRow(Pos,2,0x0c | dp); // Higher dp.
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,3,0x08 | dp);  // Higher dp.);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,4,0x10 | dp);  // Lower dp.);
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00);
    lc.setRow(Pos,5,0x10 | dp);  // Lower dp
    lc.setRow(Pos,6,0x10);
    lc.setRow(Pos,7,0x38);
  }
  if(Number==8)
  {
    lc.setRow(Pos,0,0x38);
    lc.setRow(Pos,1,0x4c);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); // 3..0 digits.
    lc.setRow(Pos,2,0x4c | dp); // Higher dp.
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,3,0x38 | dp);  // Higher dp.);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,4,0x4c | dp);  // Lower dp.);
    if(DPs==0 &&(Pos==2  || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,5,0x4c | dp);  // Lower dp
    lc.setRow(Pos,6,0x4c);
    lc.setRow(Pos,7,0x38);
  }
  if(Number==9)
  {
    lc.setRow(Pos,0,0x38);
    lc.setRow(Pos,1,0x4c);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); // 3..0 digits.
    lc.setRow(Pos,2,0x4c | dp); // Higher dp.
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,3,0x4c | dp);  // Higher dp.);
    if(DPs==1 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,4,0x3c | dp);  // Lower dp.);
    if(DPs==0 && (Pos==2 || Pos==4)) dp=0x01; else (dp=0x00); 
    lc.setRow(Pos,5,0x0c | dp);  // Lower dp
    lc.setRow(Pos,6,0x4c);
    lc.setRow(Pos,7,0x38);
  }
}
